<?php
/* --------------------------------------------------------------
	configuration.lang.inc.php 2020-03-18
	Gambio GmbH
	http://www.gambio.de
	Copyright (c) 2020 Gambio GmbH
	Released under the GNU General Public License (Version 2)
	[http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

$t_language_text_section_content_array = [
    'ACCOUNT_ADDITIONAL_INFO_DESC'                    => 'Usage of an additional address field (for additional address description)',
    'ACCOUNT_ADDITIONAL_INFO_TITLE'                   => 'Display additional address field',
    'ACCOUNT_B2B_STATUS_DESC'                         => 'Display tradesperson status in the customer registration',
    'ACCOUNT_B2B_STATUS_TITLE'                        => 'Tradesperson status',
    'ACCOUNT_COMPANY_DESC'                            => 'Display company in the customer account',
    'ACCOUNT_COMPANY_TITLE'                           => 'Company',
    'ACCOUNT_COMPANY_VAT_CHECK_DESC'                  => 'Validate VAT no. (check correct syntax)',
    'ACCOUNT_COMPANY_VAT_CHECK_TITLE'                 => 'Validate VAT No.',
    'ACCOUNT_COMPANY_VAT_GROUP_DESC'                  => 'Set to true, the customer group will be changed automatically if a correct VAT no. is used.',
    'ACCOUNT_COMPANY_VAT_GROUP_TITLE'                 => 'Automatic Pruning?',
    'ACCOUNT_COMPANY_VAT_LIVE_CHECK_DESC'             => 'Validate VAT no. live (if no syntax check available for country), live check will use validation gateway for the relevant country',
    'ACCOUNT_COMPANY_VAT_LIVE_CHECK_TITLE'            => 'Validate VAT No. Live',
    'ACCOUNT_DEFAULT_B2B_STATUS_DESC'                 => 'Default tradesperson status for customers (This value also applies, if the tradesperson status is not displayed in registration)',
    'ACCOUNT_DEFAULT_B2B_STATUS_TITLE'                => 'Default tradesperson status',
    'ACCOUNT_DOB_DESC'                                => 'Display date of birth in the customer account',
    'ACCOUNT_DOB_TITLE'                               => 'Date of Birth',
    'ACCOUNT_FAX_DESC'                                => 'Display fax number on create account page',
    'ACCOUNT_FAX_TITLE'                               => 'Fax number',
    'ACCOUNT_GENDER_DESC'                             => 'Display gender in the customer account',
    'ACCOUNT_GENDER_TITLE'                            => 'Gender',
    'ACCOUNT_NAMES_OPTIONAL_DESC'                     => 'Optional first name and last name, if the field company name is filled out',
    'ACCOUNT_NAMES_OPTIONAL_TITLE'                    => 'Optional first name and last name',
    'ACCOUNT_OPTIONS_DESC'                            => 'How do you want to manage your store login management?<br />You can choose between Customer Accounts and "One Time Orders" without creating a Customer Account (an account will be created, but the customer will not be notified)',
    'ACCOUNT_OPTIONS_TITLE'                           => 'Account Options',
    'ACCOUNT_SPLIT_STREET_INFORMATION_DESC'           => 'Store street and house number separately?',
    'ACCOUNT_SPLIT_STREET_INFORMATION_TITLE'          => 'Seperate street and house number',
    'ACCOUNT_SPLIT_STREET_INFORMATION_WARNING'        => 'External Modules (payment modules, ERP, merchandise management etc.) need to handle Street and House Number separately. If you are not sure about that, leave this option deactivated.',
    'ACCOUNT_STATE_DESC'                              => 'Display state in the customer account',
    'ACCOUNT_STATE_TITLE'                             => 'State',
    'ACCOUNT_SUBURB_DESC'                             => 'Display suburb in the customer account',
    'ACCOUNT_SUBURB_TITLE'                            => 'Suburb',
    'ACCOUNT_TELEPHONE_DESC'                          => 'Display telephone number on create account page',
    'ACCOUNT_TELEPHONE_TITLE'                         => 'Telephone number',
    'ACCOUNT_TYPE_DEFAULT_TITLE'                      => 'Default account type',
    'ACCOUNT_TYPE_DEFAULT_DESC'                       => 'What is the default account type for customer registration?',
    'ACCOUNT_VAT_BLOCK_ERROR_DESC'                    => 'Set to true, only validated VAT numbers will be accepted.',
    'ACCOUNT_VAT_BLOCK_ERROR_TITLE'                   => 'Allow Incorrect VAT No.?',
    'ACTIVATE_GIFT_SYSTEM_DESC'                       => 'Activate gift voucher system',
    'ACTIVATE_GIFT_SYSTEM_TITLE'                      => 'Activate Gift Voucher System',
    'ACTIVATE_NAVIGATOR_DESC'                         => 'Activate/deactivate product navigator in product_info, (deactivate for enhanced performance with numerous products in the system)',
    'ACTIVATE_NAVIGATOR_TITLE'                        => 'Activate Product Navigator?',
    'ACTIVATE_PAGE_TOKEN_DESC'                        => 'Activate Page-Token system?',
    'ACTIVATE_PAGE_TOKEN_TITLE'                       => 'Page-Token system',
    'ACTIVATE_REVERSE_CROSS_SELLING_DESC'             => 'Activate reverse cross-selling?',
    'ACTIVATE_REVERSE_CROSS_SELLING_TITLE'            => 'Reverse Cross-selling',
    'ADVANCED_SEARCH_DEFAULT_OPERATOR_DESC'           => 'Default search operators.',
    'ADVANCED_SEARCH_DEFAULT_OPERATOR_TITLE'          => 'Default Search Operator',
    'AFTERBUY_ACTIVATED_DESC'                         => 'Activate afterbuy module',
    'AFTERBUY_ACTIVATED_TITLE'                        => 'Active',
    'AFTERBUY_ORDERSTATUS_DESC'                       => 'Order status for exported orders',
    'AFTERBUY_ORDERSTATUS_TITLE'                      => 'Order Status',
    'AFTERBUY_PARTNERID_DESC'                         => 'Your afterbuy partner ID',
    'AFTERBUY_PARTNERID_TITLE'                        => 'Partner ID',
    'AFTERBUY_PARTNERPASS_DESC'                       => 'Your partner password for afterbuy XML module',
    'AFTERBUY_PARTNERPASS_TITLE'                      => 'Partner Password',
    'AFTERBUY_URL'                                    => 'You will find detailed afterbuy info here: <a href="http://www.xt-commerce.com/modules/wfsection/dossier-65.html" target="new">http://www.xt-commerce.com/modules/wfsection/dossier-65.html</a>',
    'AFTERBUY_USERID_DESC'                            => 'Your afterbuy user ID',
    'AFTERBUY_USERID_TITLE'                           => 'User ID',
    'ALLOW_ADD_TO_CART_DESC'                          => 'Allow customers to add products to the cart if the group setting for "show prices" is set to 0',
    'ALLOW_ADD_TO_CART_TITLE'                         => 'Allow add to cart',
    'ALLOW_DISCOUNT_ON_PRODUCTS_ATTRIBUTES_DESC'      => 'Allow customers to obtain discounts on attribute price (if main product is not a "special" product)',
    'ALLOW_DISCOUNT_ON_PRODUCTS_ATTRIBUTES_TITLE'     => 'Allow discount on product attribute?',
    'ALLOW_GUEST_TO_TELL_A_FRIEND_DESC'               => 'Allow guests to ask about a product?',
    'ALLOW_GUEST_TO_TELL_A_FRIEND_TITLE'              => 'Allow Guest to ask about a product?',
    'APPEND_PROPERTIES_MODEL_DESC'                    => 'Append properties model to the products model instead of replacing it',
    'APPEND_PROPERTIES_MODEL_TITLE'                   => 'Append properties model',
    'ATTRIBUTE_STOCK_CHECK_DESC'                      => 'Check to see if sufficent attribute stock is available',
    'ATTRIBUTE_STOCK_CHECK_TITLE'                     => 'Check attribute stock level',
    'CACHE_CHECK_DESC'                                => 'If true, then If-Modified-Since headers are maintained with cached content and appropriate HTTP headers are sent. This ensures that repeated hits to a cached page do not send the entire page to the client every time.',
    'CACHE_CHECK_TITLE'                               => 'Check if cache modified',
    'CACHE_LIFETIME_DESC'                             => 'This is the number of seconds cached content will persist',
    'CACHE_LIFETIME_TITLE'                            => 'Cache Lifetime',
    'CALCULATE_TAX_BASED_ON_VAT_ID_DESC'              => 'Show no tax for international EU customers with valid VAT-ID? The customer group configuration will be skipped.',
    'CALCULATE_TAX_BASED_ON_VAT_ID_TITLE'             => 'Show net prices depending on VAT-ID',
    'CC_KEYCHAIN_DESC'                                => 'String to encrypt CC number (please change!)',
    'CC_KEYCHAIN_TITLE'                               => 'CC String',
    'CC_NUMBER_MIN_LENGTH_DESC'                       => 'Minimum length of credit card number',
    'CC_NUMBER_MIN_LENGTH_TITLE'                      => 'Credit Card Number',
    'CC_OWNER_MIN_LENGTH_DESC'                        => 'Minimum length of credit card owner name',
    'CC_OWNER_MIN_LENGTH_TITLE'                       => 'Credit Card Owner Name',
    'CHECK_CLIENT_AGENT_DESC'                         => 'Prevent known spiders from starting a session.',
    'CHECK_CLIENT_AGENT_TITLE'                        => 'Prevent Spider Sessions',
    'CHECK_STOCK_BEFORE_SHOPPING_CART_DESC'           => 'Already checks the product stock at the product details page.',
    'CHECK_STOCK_BEFORE_SHOPPING_CART_TITLE'          => 'Check stock before shopping cart?',
    'COMPANY_NAME_DESC'                               => 'Enter your company name',
    'COMPANY_NAME_TITLE'                              => 'Company name',
    'CONFIG_CALCULATE_IMAGE_SIZE_DESC'                => 'In case one of the image dimensions (width or height) is not specified, it will be calculated using the other dimension and the aspect ratio.',
    'CONFIG_CALCULATE_IMAGE_SIZE_TITLE'               => 'Calculate Image Size',
    'CONTACT_US_EMAIL_ADDRESS_DESC'                   => 'Please enter an email address to use for normal "Contact Us" messages via the store to your office',
    'CONTACT_US_EMAIL_ADDRESS_TITLE'                  => 'Contact Us - Email Address',
    'CONTACT_US_FORWARDING_STRING_DESC'               => 'Please enter additional email addresses (comma separated) to which "Contact Us" messages sent via the store to your office can be forwarded.',
    'CONTACT_US_FORWARDING_STRING_TITLE'              => 'Contact Us - Forwarding Addresses',
    'CONTACT_US_NAME_DESC'                            => 'Please enter a name to use for normal "Contact Us" messages sent via the store to your office',
    'CONTACT_US_NAME_TITLE'                           => 'Contact Us - Email Address, Name',
    'CONTACT_US_REPLY_ADDRESS_DESC'                   => 'Please enter an email address to which customers can reply.',
    'CONTACT_US_REPLY_ADDRESS_NAME_DESC'              => 'Sender name for reply emails.',
    'CONTACT_US_REPLY_ADDRESS_NAME_TITLE'             => 'Contact Us - Reply Address, Name',
    'CONTACT_US_REPLY_ADDRESS_TITLE'                  => 'Contact Us - Reply Address',
    'CSS_INLINE_OUTPUT_DESC'                          => 'Output CSS in the head instead of link to external file',
    'CSS_INLINE_OUTPUT_TITLE'                         => 'Output CSS in head',
    'CURRENT_TEMPLATE_DESC'                           => 'Select your preferred theme for your shop.',
    'CURRENT_THEME_UPDATE_REQUIRED'                   => 'Update required',
    'CURRENT_TEMPLATE_TITLE'                          => 'Template set (theme)',
    'DATE_TIMEZONE_DESC'                              => 'Timezone',
    'DATE_TIMEZONE_TITLE'                             => 'Your timezone',
    'DB_CACHE_DESC'                                   => 'Cache SELECT query results in files to speed up slow databases.',
    'DB_CACHE_EXPIRE_DESC'                            => 'Time in seconds to rebuild cached results.',
    'DB_CACHE_EXPIRE_TITLE'                           => 'DB Cache lifetime',
    'DB_CACHE_TITLE'                                  => 'DB Cache',
    'DEFAULT_CURRENCY_DESC'                           => 'Currency used as the default currency',
    'DEFAULT_CURRENCY_TITLE'                          => 'Default Currency',
    'DEFAULT_CUSTOMERS_STATUS_ID_ADMIN_DESC'          => 'Choose the customer group the administrators!',
    'DEFAULT_CUSTOMERS_STATUS_ID_ADMIN_TITLE'         => 'Customer Group for the Administrators',
    'DEFAULT_CUSTOMERS_STATUS_ID_DESC'                => 'What would the default customer group be for a new customer?',
    'DEFAULT_CUSTOMERS_STATUS_ID_GUEST_DESC'          => 'What would the default customer group be for a guest before he/she logged in?',
    'DEFAULT_CUSTOMERS_STATUS_ID_GUEST_TITLE'         => 'Customer Group Guest',
    'DEFAULT_CUSTOMERS_STATUS_ID_TITLE'               => 'Customer Group for New Customers',
    'DEFAULT_CUSTOMERS_VAT_STATUS_ID_DESC'            => 'Customer group for customers with correct VAT no., store country != customer country',
    'DEFAULT_CUSTOMERS_VAT_STATUS_ID_LOCAL_DESC'      => 'Customer group for customers with correct VAT no., store country = customer country',
    'DEFAULT_CUSTOMERS_VAT_STATUS_ID_LOCAL_TITLE'     => 'Customer Group - Correct VAT No. (Store Country)',
    'DEFAULT_CUSTOMERS_VAT_STATUS_ID_TITLE'           => 'Customer Group - Correct VAT No. (foreign countries)',
    'DEFAULT_LANGUAGE_DESC'                           => 'Language used as the default language',
    'DEFAULT_LANGUAGE_TITLE'                          => 'Default Language',
    'DEFAULT_ORDERS_STATUS_ID_DESC'                   => 'Default order status when a new order is placed.',
    'DEFAULT_ORDERS_STATUS_ID_TITLE'                  => 'Default Order Status',
    'DELETE_GUEST_ACCOUNT_DESC'                       => 'Should guest accounts be deleted after placing orders? (Order data will be saved)',
    'DELETE_GUEST_ACCOUNT_TITLE'                      => 'Deleting Guest Accounts',
    'DIR_FS_CACHE_DESC'                               => 'The directory where the cached files are saved',
    'DIR_FS_CACHE_TITLE'                              => 'Cache Directory',
    'DISPLAY_CART_DESC'                               => 'Display the shopping cart after adding a product, switch to cart or remain on the current page?',
    'DISPLAY_CART_TITLE'                              => 'Display Cart After Adding a Product?',
    'DISPLAY_CONDITIONS_ON_CHECKOUT_DESC'             => 'Display and sign the conditions during the order process',
    'DISPLAY_CONDITIONS_ON_CHECKOUT_TITLE'            => 'Display Conditions Check at Checkout',
    'DISPLAY_PAGE_PARSE_TIME_DESC'                    => 'Display the page parse time (store page parse time must be enabled)',
    'DISPLAY_PAGE_PARSE_TIME_TITLE'                   => 'Display The Page Parse Time',
    'DISPLAY_PRICE_WITH_TAX_DESC'                     => 'Display prices with tax included (true) or add the tax at the end (false)',
    'DISPLAY_PRICE_WITH_TAX_TITLE'                    => 'Display Prices incl. tax',
    'DISPLAY_REVOCATION_ON_CHECKOUT_DESC'             => 'Display right of revocation on checkout_confirmation?',
    'DISPLAY_REVOCATION_ON_CHECKOUT_TITLE'            => 'Display Right of Revocation?',
    'DOWNLOAD_BY_REDIRECT_DESC'                       => 'Use browser redirection to download. Disable on non-Unix systems.',
    'DOWNLOAD_BY_REDIRECT_TITLE'                      => 'Download by redirect',
    'DOWNLOAD_ENABLED_DESC'                           => 'Enable the product download functions.',
    'DOWNLOAD_ENABLED_TITLE'                          => 'Enable download',
    'DOWNLOAD_MAX_COUNT_DESC'                         => 'Set the maximum number of downloads; 0 means no download authorized.',
    'DOWNLOAD_MAX_COUNT_TITLE'                        => 'Maximum number of downloads',
    'DOWNLOAD_MAX_DAYS_DESC'                          => 'Set number of days before the download link expires; 0 means no limit.',
    'DOWNLOAD_MAX_DAYS_TITLE'                         => 'Expires (days)',
    'DOWNLOAD_MIN_ORDERS_STATUS_DESC'                 => 'Order status for which the download is enabled.',
    'DOWNLOAD_MIN_ORDERS_STATUS_TITLE'                => 'Download Order Status',
    'DOWNLOAD_STOCK_CHECK_DESC'                       => 'Check to see if there is sufficent download stock available',
    'DOWNLOAD_STOCK_CHECK_TITLE'                      => 'Check download stock level',
    'DOWNLOAD_UNALLOWED_PAYMENT_DESC'                 => 'Unauthorized payment modules for downloads. List, comma separated, e.g. {banktransfer,cod,invoice,moneyorder}',
    'DOWNLOAD_UNALLOWED_PAYMENT_TITLE'                => 'Unallowed Payment Modules',
    'EMAIL_BILLING_ADDRESS_DESC'                      => 'Please enter an email address to use for sending emails over the <b>Billing system</b> (order confirmations, status changes, etc.).',
    'EMAIL_BILLING_ADDRESS_TITLE'                     => 'Billing - Email Address',
    'EMAIL_BILLING_FORWARDING_STRING_DESC'            => 'Please enter additional addresses to use for emails from the <b>Billing System</b> (comma separated)',
    'EMAIL_BILLING_FORWARDING_STRING_TITLE'           => 'Billing - Forwarding Addresses',
    'EMAIL_BILLING_NAME_DESC'                         => 'Please enter a name to use for sending emails over the <b>Billing System</b> (order confirmations, status changes, etc.).',
    'EMAIL_BILLING_NAME_TITLE'                        => 'Billing - Email Address, Name',
    'EMAIL_BILLING_REPLY_ADDRESS_DESC'                => 'Please enter an email address to which your customers can reply.',
    'EMAIL_BILLING_REPLY_ADDRESS_NAME_DESC'           => 'Please enter a name to use for the email address for replies from your customers.',
    'EMAIL_BILLING_REPLY_ADDRESS_NAME_TITLE'          => 'Billing - Reply Address, Name',
    'EMAIL_BILLING_REPLY_ADDRESS_TITLE'               => 'Billing - Reply Address',
    'EMAIL_BILLING_SUBJECT_DESC'                      => 'Please enter an email subject for the <b>Billing</b> messages via the store to your office.',
    'EMAIL_BILLING_SUBJECT_ORDER_DESC'                => 'Please enter a subject for order mails generated from xtc. (like <b>our order {$nr},{$date}</b>) Note: you can use {$nr},{$date},{$firstname},{$lastname}. This field is required.',
    'EMAIL_BILLING_SUBJECT_ORDER_TITLE'               => 'Billing - Order Mail Subject',
    'EMAIL_BILLING_SUBJECT_TITLE'                     => 'Billing - Email Subject',
    'EMAIL_FROM_DESC'                                 => 'The Email address used in (sent) emails.',
    'EMAIL_FROM_TITLE'                                => 'Email from',
    'EMAIL_LINEFEED_DESC'                             => 'Defines the character sequence used to separate mail headers.',
    'EMAIL_LINEFEED_TITLE'                            => 'Email Line Feeds',
    'EMAIL_MAX_LIMIT_TITLE'                           => 'Max Newsletter-Mails per Script',
    'EMAIL_SIGNATURE_DESC'                            => 'You can use the variables {$EMAIL_SIGNATURE_HTML} and {$EMAIL_SIGNATURE_TEXT} in the e-mail templates to insert this signature',
    'EMAIL_SIGNATURE_TITLE'                           => 'Email Signature in order mail',
    'EMAIL_SUPPORT_ADDRESS_DESC'                      => 'Please enter an email address to use for sending emails over the <b>Support System</b> (account creation, password changes, etc.).',
    'EMAIL_SUPPORT_ADDRESS_TITLE'                     => 'Technical Support - Email Address',
    'EMAIL_SUPPORT_FORWARDING_STRING_DESC'            => 'Please enter additional email addresses to which the emails from the <b>Support System</b> (comma separated) can be forwarded.',
    'EMAIL_SUPPORT_FORWARDING_STRING_TITLE'           => 'Technical Support - Forwarding Addresses',
    'EMAIL_SUPPORT_NAME_DESC'                         => 'Please enter a name to use for sending emails over the <b>Support System</b> (account creation, password changes).',
    'EMAIL_SUPPORT_NAME_TITLE'                        => 'Technical Support - Email Address, Name',
    'EMAIL_SUPPORT_REPLY_ADDRESS_DESC'                => 'Please enter an email address to which customers can reply.',
    'EMAIL_SUPPORT_REPLY_ADDRESS_NAME_DESC'           => 'Please enter an email address to which customers can reply.',
    'EMAIL_SUPPORT_REPLY_ADDRESS_NAME_TITLE'          => 'Technical Support - Reply Address, Name',
    'EMAIL_SUPPORT_REPLY_ADDRESS_TITLE'               => 'Technical Support - Reply Address',
    'EMAIL_SUPPORT_SUBJECT_DESC'                      => 'Please enter an email subject for the <b>Support System</b> messages via the store to your office.',
    'EMAIL_SUPPORT_SUBJECT_TITLE'                     => 'Technical Support - Email Subject',
    'EMAIL_TRANSPORT_DESC'                            => 'Defines if this server uses a local connection to the sendmail program or an SMTP connection via TCP/IP. Servers running on Windows and MacOS should change this setting to SMTP.',
    'EMAIL_TRANSPORT_TITLE'                           => 'Email Transport Method',
    'EMAIL_USE_HTML_DESC'                             => 'Send emails in HTML format',
    'EMAIL_USE_HTML_TITLE'                            => 'Send HTML E-Mails',
    'ENTRY_CITY_MIN_LENGTH_DESC'                      => 'Minimum length of city',
    'ENTRY_CITY_MIN_LENGTH_TITLE'                     => 'City',
    'ENTRY_COMPANY_MIN_LENGTH_DESC'                   => 'Minimum length of company name',
    'ENTRY_COMPANY_MIN_LENGTH_TITLE'                  => 'Company',
    'ENTRY_DOB_MIN_LENGTH_DESC'                       => 'Minimum length of date of birth',
    'ENTRY_DOB_MIN_LENGTH_TITLE'                      => 'Date of Birth',
    'ENTRY_EMAIL_ADDRESS_CHECK_DESC'                  => 'Verify email address through a DNS server',
    'ENTRY_EMAIL_ADDRESS_CHECK_TITLE'                 => 'Verify Email Addresses Through DNS',
    'ENTRY_EMAIL_ADDRESS_MIN_LENGTH_DESC'             => 'Minimum length of email address',
    'ENTRY_EMAIL_ADDRESS_MIN_LENGTH_TITLE'            => 'Email Address',
    'ENTRY_FIRST_NAME_MIN_LENGTH_DESC'                => 'Minimum length of first name',
    'ENTRY_FIRST_NAME_MIN_LENGTH_TITLE'               => 'First Name',
    'ENTRY_HOUSENUMBER_MIN_LENGTH_DESC'               => 'Minimum length of house number',
    'ENTRY_HOUSENUMBER_MIN_LENGTH_TITLE'              => 'House Number',
    'ENTRY_LAST_NAME_MIN_LENGTH_DESC'                 => 'Minimum length of last name',
    'ENTRY_LAST_NAME_MIN_LENGTH_TITLE'                => 'Last Name',
    'ENTRY_PASSWORD_MIN_LENGTH_DESC'                  => 'Minimum length of password',
    'ENTRY_PASSWORD_MIN_LENGTH_TITLE'                 => 'Password',
    'ENTRY_POSTCODE_MIN_LENGTH_DESC'                  => 'Minimum length of postcode (ZIP)',
    'ENTRY_POSTCODE_MIN_LENGTH_TITLE'                 => 'Postcode (ZIP)',
    'ENTRY_STATE_MIN_LENGTH_DESC'                     => 'Minimum length of state',
    'ENTRY_STATE_MIN_LENGTH_TITLE'                    => 'State',
    'ENTRY_STREET_ADDRESS_MIN_LENGTH_DESC'            => 'Minimum length of street address',
    'ENTRY_STREET_ADDRESS_MIN_LENGTH_TITLE'           => 'Street Address',
    'ENTRY_TELEPHONE_MIN_LENGTH_DESC'                 => 'Minimum length of telephone number',
    'ENTRY_TELEPHONE_MIN_LENGTH_TITLE'                => 'Telephone Number',
    'ERROR_IMAGE_QUALITY'                             => 'Insert a numeric value between 0 and 100.',
    'ERROR_MO_PICS'                                   => 'Insert a positive numeric value.',
    'ERROR_PRODUCT_IMAGE_INFO_BEVEL'                  => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_INFO_DROP_SHADDOW'           => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_INFO_ELLIPSE'                => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_INFO_FRAME'                  => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_INFO_GREYSCALE'              => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_INFO_HEIGHT'                 => 'Insert a positive numeric value.',
    'ERROR_PRODUCT_IMAGE_INFO_MERGE'                  => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_INFO_MOTION_BLUR'            => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_INFO_ROUND_EDGES'            => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_INFO_WIDTH'                  => 'Insert a positive numeric value.',
    'ERROR_PRODUCT_IMAGE_POPUP_BEVEL'                 => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_POPUP_DROP_SHADDOW'          => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_POPUP_ELLIPSE'               => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_POPUP_FRAME'                 => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_POPUP_GREYSCALE'             => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_POPUP_HEIGHT'                => 'Insert a positive numeric value.',
    'ERROR_PRODUCT_IMAGE_POPUP_MERGE'                 => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_POPUP_MOTION_BLUR'           => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_POPUP_ROUND_EDGES'           => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_POPUP_WIDTH'                 => 'Insert a positive numeric value.',
    'ERROR_PRODUCT_IMAGE_THUMBNAIL_BEVEL'             => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_THUMBNAIL_DROP_SHADDOW'      => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_THUMBNAIL_ELLIPSE'           => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_THUMBNAIL_FRAME'             => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_THUMBNAIL_GREYSCALE'         => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_THUMBNAIL_HEIGHT'            => 'Insert a positive numeric value.',
    'ERROR_PRODUCT_IMAGE_THUMBNAIL_MERGE'             => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_THUMBNAIL_MOTION_BLUR'       => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_THUMBNAIL_ROUND_EDGES'       => 'Insert a value according to the description below.',
    'ERROR_PRODUCT_IMAGE_THUMBNAIL_WIDTH'             => 'Insert a positive numeric value.',
    'ERROR_REPORT_EMAIL_DESC'                         => 'Leave the input field empty, if you don\'t want to recieve any error reports via email.<br/>Gambio Support: debug@gambio-support.de',
    'ERROR_REPORT_EMAIL_TITLE'                        => 'Email error report to',
    'EXPECTED_PRODUCTS_FIELD_DESC'                    => 'The column to sort by in the expected product announcement box.',
    'EXPECTED_PRODUCTS_FIELD_TITLE'                   => 'Expected Product Sort Field',
    'EXPECTED_PRODUCTS_SORT_DESC'                     => 'This is the sort order used in the expected product announcement box.',
    'EXPECTED_PRODUCTS_SORT_TITLE'                    => 'Expected Products Sort Order',
    'GAMBIO_SHOP_KEY_DESC'                            => 'Please enter your Gambio Shop-Key, that you obtained through your login in our Gambio Customer Area at (<a href="http://www.gambio-support.de/" target="_blank">www.gambio-support.de</a>). By entering your Gambio Shop-Key in the Gambio Admin of your shop, you gain many advantages: In the future, you will be notified about updates for your shop via the Admin-Infobox on the upper right of the administration. In order to process your support issues in a most efficient and fast way, we need several information about your shop, that is automatically submitted to our Gambio Customer Area, when you deposit your Shop-Key here. <br /> <br /> By entering your Gambio Shop-Key, they key itself, the URL to your online shop, the currently activated language in your online shop and relevant version information from your shop and installed modules (hereinafer referred to as "shop data") will be transferred to the Customer Area. Your shop data will be transferred and updated automatically by your online shop, thus the data available for us is always up to date. <br /> <br /> Should you no longer want your shop to transfer your shop data to the Customer Area, click "Delete Shop-Key". Despite the aforementioned data, no further information will be transferred. We will under no circumstances forward your shop data to third parties and only use it in the context that is necessary for providing the services or carrying out the contract. You may review the transmitted shop data anytime in the Customer Area and delete it as and when required.<br /> <br /> For details, please read our <a href="http://www.gambio.de/Datenschutzerklaerung.html" target="_blank"><u>privacy notice</u></a>.<br /> <br /> <a href="#" class="button" onclick="$(\'input[name=GAMBIO_SHOP_KEY]\').val(\'\'); $(\'form[name=configuration]\').submit(); return false;">Delete Shop-Key</a><br /> <br /> <br /> Following shop data will be transferred to the Customer Area:',
    'GAMBIO_SHOP_KEY_TITLE'                           => 'Gambio Shop-Key',
    'GM_LIVE_CHECK_NOT_READY'                         => '<br /><br /><font color="#ff0000"><strong>Attention!</strong></font> The php function fsockopen and curl are not available on this server, so you cannot use this option.',
    'GM_SET_OUT_OF_STOCK_ATTRIBUTES_DESC'             => 'Hide attributes that are out of stock?</span><span class="tooltip-icon" data-gx-widget="tooltip_icon" data-tooltip_icon-type="warning">Also activate the following option to deactivate any out-of-stock products.',
    'GM_SET_OUT_OF_STOCK_ATTRIBUTES_SHOW_DESC'        => 'Show stock attributes',
    'GM_SET_OUT_OF_STOCK_ATTRIBUTES_SHOW_TITLE'       => 'Show Stock Attributes',
    'GM_SET_OUT_OF_STOCK_ATTRIBUTES_TITLE'            => 'Deactivate Attributes',
    'GM_SET_OUT_OF_STOCK_PRODUCTS_DESC'               => 'Deactivate out-of-stock products?</span><span class="tooltip-icon" data-gx-widget="tooltip_icon" data-tooltip_icon-type="warning">Set "Check stock level" and "Subtract stock" on "true" and "Allow Checkout" on "false" to use this option.',
    'GM_SET_OUT_OF_STOCK_PRODUCTS_TITLE'              => 'Deactivate Products',
    'GOOGLE_CONVERSION_DESC'                          => 'Track the conversion keywords at orders',
    'GOOGLE_CONVERSION_ID_DESC'                       => 'Your Google conversion ID',
    'GOOGLE_CONVERSION_ID_TITLE'                      => 'Conversion ID',
    'GOOGLE_CONVERSION_LABEL_DESC'                    => 'Your Google Conversion Label',
    'GOOGLE_CONVERSION_LABEL_TITLE'                   => 'Conversion Label',
    'GOOGLE_CONVERSION_TITLE'                         => 'Google Adword-Conversion Tracking',
    'GOOGLE_LANG_DESC'                                => 'ISO code of language used',
    'GOOGLE_LANG_TITLE'                               => 'Google Language',
    'GROUP_CHECK_DESC'                                => 'Only allow defined customer groups access to individual categories, products and content elements (after activation, input fields will appear in categories, products and in the content manager',
    'GROUP_CHECK_TITLE'                               => 'Customer Status Check',
    'GZIP_COMPRESSION_DESC'                           => 'Enable HTTP GZip compression.',
    'GZIP_COMPRESSION_TITLE'                          => 'Enable GZip Compression',
    'GZIP_LEVEL_DESC'                                 => 'Use a compression level from 1 to 9 (1 = minimum, 9 = maximum).',
    'GZIP_LEVEL_TITLE'                                => 'Compression Level',
    'HEADING_IMAGE_HEIGHT_DESC'                       => 'The pixel height of header images',
    'HEADING_IMAGE_HEIGHT_TITLE'                      => 'Heading Image Height',
    'HEADING_IMAGE_WIDTH_DESC'                        => 'The pixel width of header images',
    'HEADING_IMAGE_WIDTH_TITLE'                       => 'Heading Image Width',
    'HEADING_SUB_TITLE'                               => 'Configuration',
    'HTML_COMPRESSION_DESC'                           => 'HTML Compression removes unneeded Whitespaces from the code of generated pages, but makes debugging errors harder.',
    'HTML_COMPRESSION_TITLE'                          => 'Enable HTML Compression',
    'HTTP_CACHING_DESC'                               => 'By activating HTTP Caching the browser tries to load the javascripts from local cache first.',
    'HTTP_CACHING_TITLE'                              => 'HTTP Caching',
    'IMAGE_MANIPULATOR_DESC'                          => 'Image Manipulator for GD2 or GD1',
    'IMAGE_MANIPULATOR_TITLE'                         => 'GDlib processing',
    'IMAGE_QUALITY_DESC'                              => 'Image quality (0= highest compression, 100=best quality)',
    'IMAGE_QUALITY_TITLE'                             => 'Image Quality',
    'IMAGE_REQUIRED_DESC'                             => 'Enable the display of broken images. Good for developers.',
    'IMAGE_REQUIRED_TITLE'                            => 'Image Required',
    'LOG_CONFIGURATION_DESC'                          => 'Activation and Deactivation of logging output data by output media and error level.',
    'LOG_CONFIGURATION_TITLE'                         => 'Output options',
    'LOG_SQL_BACKEND_DESC'                            => 'Log SQL-queries changing data in database.',
    'LOG_SQL_BACKEND_TITLE'                           => 'SQL-Logging in Backend',
    'LOG_SQL_FRONTEND_DESC'                           => 'Log SQL-queries changing data in database.',
    'LOG_SQL_FRONTEND_TITLE'                          => 'SQL-Logging in Frontend',
    'LOGGING_ENABLED_DESC'                            => 'Enable / Disable logging for the entire shop',
    'LOGGING_ENABLED_TITLE'                           => 'Activate logging',
    'LOGGING_GROUP'                                   => 'Logging group',
    'LOGGING_LEVEL_ERROR'                             => 'Error',
    'LOGGING_LEVEL_NOTICE'                            => 'Notice',
    'LOGGING_LEVEL_WARNING'                           => 'Warning',
    'LOGGING_OUTPUT_BACKTRACE'                        => 'Backtrace',
    'LOGGING_OUTPUT_CLASS_DATA'                       => 'Class',
    'LOGGING_OUTPUT_CODE_SNIPPET'                     => 'Code',
    'LOGGING_OUTPUT_FILEPATH'                         => 'Filepaths',
    'LOGGING_OUTPUT_FUNCTION_DATA'                    => 'Function',
    'LOGGING_OUTPUT_OUTPUT'                           => 'Output',
    'LOGGING_OUTPUT_REQUEST_DATA'                     => 'Request',
    'LOGGING_OUTPUT_SESSION_DATA'                     => 'Session',
    'LOGGING_OUTPUT_TYPE_FILE'                        => 'File',
    'LOGGING_OUTPUT_TYPE_HTML_FILE'                   => 'HTML file',
    'LOGGING_OUTPUT_TYPE_MAIL'                        => 'Mail',
    'LOGGING_OUTPUT_TYPE_SCREEN'                      => 'Screen',
    'MAX_ADDRESS_BOOK_ENTRIES_DESC'                   => 'Maximum address book entries a customer is allowed to have',
    'MAX_ADDRESS_BOOK_ENTRIES_TITLE'                  => 'Address Book Entries',
    'MAX_DISPLAY_ALSO_PURCHASED_DAYS_DESC'            => 'Maximum number of days old the order of also purchased products must be',
    'MAX_DISPLAY_ALSO_PURCHASED_DAYS_TITLE'           => 'Maximum Days of also purchased products',
    'MAX_DISPLAY_ALSO_PURCHASED_DESC'                 => 'Maximum number of products to display in the "This Customer Also Purchased" box',
    'MAX_DISPLAY_ALSO_PURCHASED_TITLE'                => 'Also Purchased',
    'MAX_DISPLAY_BESTSELLERS_DESC'                    => 'Maximum number of best sellers to display',
    'MAX_DISPLAY_BESTSELLERS_TITLE'                   => 'Best Sellers',
    'MAX_DISPLAY_CATEGORIES_PER_ROW_DESC'             => 'How many categories to list per row',
    'MAX_DISPLAY_CATEGORIES_PER_ROW_TITLE'            => 'Categories to List Per Row',
    'MAX_DISPLAY_CROSSSELLING_DESC'                   => 'Maximum number of products to display in the "This product is compatible to" box',
    'MAX_DISPLAY_CROSSSELLING_TITLE'                  => 'Reverse Cross Marketing',
    'MAX_DISPLAY_MANUFACTURER_NAME_LEN_DESC'          => 'Used in the manufacturer box; maximum length of manufacturer name',
    'MAX_DISPLAY_MANUFACTURER_NAME_LEN_TITLE'         => 'Length of Manufacturer Name',
    'MAX_DISPLAY_MANUFACTURERS_IN_A_LIST_DESC'        => 'Used in the manufacturer box; when the number of manufacturers exceeds this number, a drop down list will be displayed instead of the default list',
    'MAX_DISPLAY_MANUFACTURERS_IN_A_LIST_TITLE'       => 'Manufacturer List Threshold',
    'MAX_DISPLAY_NEW_PRODUCTS_DAYS_DESC'              => 'Maximum number of days to view new products',
    'MAX_DISPLAY_NEW_PRODUCTS_DAYS_TITLE'             => 'Maximum days for new products',
    'MAX_DISPLAY_NEW_PRODUCTS_DESC'                   => 'Maximum number of new products to display in a category <img src="html/assets/images/legacy/gm_icons/warning.png" height="16" width="16" class="template_warning" />',
    'MAX_DISPLAY_NEW_PRODUCTS_TITLE'                  => 'New Products Module',
    'MAX_DISPLAY_NEW_REVIEWS_DESC'                    => 'Maximum number of new reviews to display',
    'MAX_DISPLAY_NEW_REVIEWS_TITLE'                   => 'New Reviews',
    'MAX_DISPLAY_ORDER_HISTORY_DESC'                  => 'Maximum number of orders to display on the order history page',
    'MAX_DISPLAY_ORDER_HISTORY_TITLE'                 => 'Order History',
    'MAX_DISPLAY_PAGE_LINKS_DESC'                     => 'Number of "number" links use for page sets',
    'MAX_DISPLAY_PAGE_LINKS_TITLE'                    => 'Page Links',
    'MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX_DESC'  => 'Maximum number of products to display in the customer order history box',
    'MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX_TITLE' => 'Customer Order History Box',
    'MAX_DISPLAY_PRODUCTS_NEW_DESC'                   => 'Maximum number of new products to display on the new products page',
    'MAX_DISPLAY_PRODUCTS_NEW_TITLE'                  => 'New Products Listing',
    'MAX_DISPLAY_SEARCH_RESULTS_DESC'                 => 'Number of products to list',
    'MAX_DISPLAY_SEARCH_RESULTS_TITLE'                => 'Search Results',
    'MAX_DISPLAY_SPECIAL_PRODUCTS_DESC'               => 'Maximum number of products on special to view',
    'MAX_DISPLAY_SPECIAL_PRODUCTS_TITLE'              => 'Special Products',
    'MAX_DISPLAY_UPCOMING_PRODUCTS_DESC'              => 'Maximum number of new products to be displayed',
    'MAX_DISPLAY_UPCOMING_PRODUCTS_TITLE'             => 'New Products',
    'MAX_MANUFACTURERS_LIST_DESC'                     => 'Used in the manufacturer box; when this value is "1" the standard drop down list will be used for the manufacturer box, or a list box with the specified number of rows will be displayed.',
    'MAX_MANUFACTURERS_LIST_TITLE'                    => 'Manufacturer List',
    'MAX_PRODUCTS_QTY_DESC'                           => 'Maximum quantity input length',
    'MAX_PRODUCTS_QTY_TITLE'                          => 'Maximum Quantity',
    'MAX_RANDOM_SELECT_NEW_DESC'                      => 'How many records to select from to choose one random new product to view',
    'MAX_RANDOM_SELECT_NEW_TITLE'                     => 'Selection of Random New Products',
    'MAX_RANDOM_SELECT_REVIEWS_DESC'                  => 'How many records to select from to choose one random product review',
    'MAX_RANDOM_SELECT_REVIEWS_TITLE'                 => 'Selection of Random Reviews',
    'MAX_RANDOM_SELECT_SPECIALS_DESC'                 => 'How many records to select from to choose one random product special to view',
    'MAX_RANDOM_SELECT_SPECIALS_TITLE'                => 'Selection of Products on Special',
    'META_AUTHOR_DESC'                                => '<meta name="author">',
    'META_AUTHOR_TITLE'                               => 'author',
    'META_COMPANY_DESC'                               => '<meta name="conpany">',
    'META_COMPANY_TITLE'                              => 'company',
    'META_DESCRIPTION_DESC'                           => '<meta name="description">',
    'META_DESCRIPTION_TITLE'                          => 'Description',
    'META_KEYWORDS_DESC'                              => '<meta name="keywords">',
    'META_KEYWORDS_NUMBER_DESC'                       => 'Number of keywords',
    'META_KEYWORDS_NUMBER_TITLE'                      => 'Number of meta keywords',
    'META_KEYWORDS_TITLE'                             => 'Keywords',
    'META_MIN_KEYWORD_LENGTH_DESC'                    => 'Min. length of a single keyword (generated from the product description)',
    'META_MIN_KEYWORD_LENGTH_TITLE'                   => 'Min. meta keyword length',
    'META_PUBLISHER_DESC'                             => '<meta name="publisher">',
    'META_PUBLISHER_TITLE'                            => 'publisher',
    'META_REPLY_TO_DESC'                              => '<meta name="reply to">',
    'META_REPLY_TO_TITLE'                             => 'reply-to',
    'META_REVISIT_AFTER_DESC'                         => '<meta name="revisit after">',
    'META_REVISIT_AFTER_TITLE'                        => 'revisit-after',
    'META_ROBOTS_DESC'                                => '<meta name="robots">',
    'META_ROBOTS_TITLE'                               => 'robots',
    'META_TOPIC_DESC'                                 => '<meta name="page topic">',
    'META_TOPIC_TITLE'                                => 'page-topic',
    'MIN_DISPLAY_ALSO_PURCHASED_DESC'                 => 'Minimum number of products to display in the "This Customer Also Purchased" box',
    'MIN_DISPLAY_ALSO_PURCHASED_TITLE'                => 'Also Purchased',
    'MIN_DISPLAY_BESTSELLERS_DESC'                    => 'Minimum number of best sellers to display',
    'MIN_DISPLAY_BESTSELLERS_TITLE'                   => 'Best Sellers',
    'MO_PICS_DESC'                                    => 'if this number is set > 0 , you will be able to upload/display more images per product',
    'MO_PICS_TITLE'                                   => 'Number of product images',
    'MODULE_BRICKFOX_EXCLUDE_CATEGORIES_DESC'         => 'Enter the exclude categories IDs here (comma separated)',
    'MODULE_BRICKFOX_EXCLUDE_CATEGORIES_TITLE'        => 'excluded  Categories',
    'MODULE_BRICKFOX_EXCLUDE_PRODUCTS_DESC'           => 'Enter the item numbers of excluded products (comma separated)',
    'MODULE_BRICKFOX_EXCLUDE_PRODUCTS_TITLE'          => 'excluded products',
    'MODULE_BRICKFOX_PASSWORD_DESC'                   => 'Enter the brickfox password here',
    'MODULE_BRICKFOX_PASSWORD_TITLE'                  => 'brickfox Password',
    'MODULE_BRICKFOX_PORT_DESC'                       => 'Enter the Port for access to the brickfox server',
    'MODULE_BRICKFOX_PORT_TITLE'                      => 'Port',
    'MODULE_BRICKFOX_STATUS_DESC'                     => '<br />You can find further information about our products <a href="http://www.brickfox.de/multikanalvertrieb-produkte/online-marktplatz-marketing.html">Marketplace Connect</a> and <a href="http://www.brickfox.de/multikanalvertrieb-produkte/produktsuchmaschinen-marketing.html">Product Connect</a> on our website at <a href="http://www.brickfox.de">www.brickfox.de</a>. To make an inquiry please use our <a href="http://www.brickfox.de/kontakt/anfrage-online-vertrieb.html">inquiry form</a>.<br />',
    'MODULE_BRICKFOX_STATUS_TITLE'                    => 'active<br /><br />',
    'MODULE_BRICKFOX_URL_DESC'                        => 'Enter the brickfox server URL here',
    'MODULE_BRICKFOX_URL_TITLE'                       => 'URL',
    'MODULE_BRICKFOX_USERNAME_DESC'                   => 'Enter the brickfox username here',
    'MODULE_BRICKFOX_USERNAME_TITLE'                  => 'brickfox User',
    'MODULE_ORDER_TOTAL_INSTALLED_DESC'               => 'List of order_total module filenames separated by a semicolon. This is automatically updated; no need to edit. (Example: ot_subtotal.php;ot_tax.php;ot_shipping.php;ot_total.php)',
    'MODULE_ORDER_TOTAL_INSTALLED_TITLE'              => 'Installed Order Total Modules',
    'MODULE_PAYMENT_INSTALLED_DESC'                   => 'List of payment module filenames separated by a semicolon. This is automatically updated; no need to edit. (Example: cc.php;cod.php;paypal.php)',
    'MODULE_PAYMENT_INSTALLED_TITLE'                  => 'Installed Payment Modules',
    'MODULE_SHIPPING_INSTALLED_DESC'                  => 'List of shipping module filenames separated by a semicolon. This is automatically updated; no need to edit. (Example: ups.php;flat.php;item.php)',
    'MODULE_SHIPPING_INSTALLED_TITLE'                 => 'Installed Shipping Modules',
    'MOVE_ONLY_IF_NO_GUEST_TITLE'                     => 'Move guest account if automatic pruning is active',
    'PAYPAL_API_PWD_DESC'                             => 'Enter the password here',
    'PAYPAL_API_PWD_TITLE'                            => 'PayPal API Password (Live)',
    'PAYPAL_API_SANDBOX_PWD_DESC'                     => 'Enter the password here',
    'PAYPAL_API_SANDBOX_PWD_TITLE'                    => 'PayPal API Password (Sandbox)',
    'PAYPAL_API_SANDBOX_SIGNATURE_DESC'               => 'Enter the API signature here',
    'PAYPAL_API_SANDBOX_SIGNATURE_TITLE'              => 'PayPal API Signature (Sandbox)',
    'PAYPAL_API_SANDBOX_USER_DESC'                    => 'Enter the username here',
    'PAYPAL_API_SANDBOX_USER_TITLE'                   => 'PayPal API User (Sandbox)',
    'PAYPAL_API_SIGNATURE_DESC'                       => 'Enter the API signature here',
    'PAYPAL_API_SIGNATURE_TITLE'                      => 'PayPal API Signature (Live)',
    'PAYPAL_API_USER_DESC'                            => 'Enter the username here',
    'PAYPAL_API_USER_TITLE'                           => 'PayPal API User (Live)',
    'PAYPAL_COUNTRY_MODE_DESC'                        => 'Select the country mode setting. Some PayPal functions are only available in the UK (i.e. Direct Payment )',
    'PAYPAL_COUNTRY_MODE_TITLE'                       => 'PayPal Country Mode',
    'PAYPAL_ERROR_EMAIL_ADDRESS_DESC'                 => 'Enter the correct email address',
    'PAYPAL_ERROR_EMAIL_ADDRESS_TITLE'                => 'PayPal Error Email Address',
    'PAYPAL_EXPRESS_ADDRESS_CHANGE_DESC'              => 'Allows customer to change the address data sent to you by PayPal',
    'PAYPAL_EXPRESS_ADDRESS_CHANGE_TITLE'             => 'PayPal Express Address Data',
    'PAYPAL_EXPRESS_ADDRESS_OVERRIDE_DESC'            => 'Allows you to change the address data sent to you by PayPal (existing account)',
    'PAYPAL_EXPRESS_ADDRESS_OVERRIDE_TITLE'           => 'Shipping Address',
    'PAYPAL_EXPRESS_PAYMENTACTION_DESC'               => 'Select the PayPal express method here<br /><strong>Sale</strong> - This is a final sale for which you are requesting payment<br /><strong>Authorization</strong> - This payment is a basic authorization subject to settlement with PayPal Authorization and Capture.<br /><strong>Order</strong> - This payment is an order authorization subject to settlement with PayPal Authorization and Capture.',
    'PAYPAL_EXPRESS_PAYMENTACTION_TITLE'              => 'PayPal Express Methods',
    'PAYPAL_MODE_DESC'                                => 'Live or Test Mode',
    'PAYPAL_MODE_TITLE'                               => 'PayPal Mode:',
    'PAYPAL_ORDER_STATUS_PENDING_ID_DESC'             => 'Select the order status for a transaction that has not yet been processed by PayPal',
    'PAYPAL_ORDER_STATUS_PENDING_ID_TITLE'            => 'Order Status "In Progress"',
    'PAYPAL_ORDER_STATUS_REJECTED_ID_DESC'            => 'Select the order status for a rejected transaction',
    'PAYPAL_ORDER_STATUS_REJECTED_ID_TITLE'           => 'Order Status "Rejected"',
    'PAYPAL_ORDER_STATUS_SUCCESS_ID_DESC'             => 'Select the order status for a successful transaction',
    'PAYPAL_ORDER_STATUS_SUCCESS_ID_TITLE'            => 'Order Status OK',
    'PAYPAL_ORDER_STATUS_TMP_ID_DESC'                 => 'Select the temporary order status',
    'PAYPAL_ORDER_STATUS_TMP_ID_TITLE'                => 'Temporary Order Status',
    'PAYPAL_SHOP_LOGO_DESC'                           => 'URL for the image you want to appear at the top left of the payment page.<br />The image has a maximum size of 750 pixels wide by 90 pixels high.<br />e.g. ',
    'PAYPAL_SHOP_LOGO_TITLE'                          => 'Shop logo',
    'PREFER_GZHANDLER_DESC'                           => 'Activate this option if GZip compression does not work by default.',
    'PREFER_GZHANDLER_TITLE'                          => 'Prefer ob_gzhandler',
    'PRICE_IS_BRUTTO_DESC'                            => 'Use of prices with tax in admin',
    'PRICE_IS_BRUTTO_TITLE'                           => 'Gross Admin',
    'PRICE_PRECISION_DESC'                            => 'Gross/Net precision',
    'PRICE_PRECISION_TITLE'                           => 'Gross/Net Precision',
    'PRODUCT_IMAGE_INFO_BEVEL_DESC'                   => 'Bevel<p>Edges look chamfered thanks to the shade</p>Default values: <span style="display:block">(8,FFCCCC,330000)</span><p>Usage: <span style="display:block">(edge width, hex light colour, hex dark colour)</span></p><img src="html/assets/images/legacy/config_bevel.gif">',
    'PRODUCT_IMAGE_INFO_BEVEL_TITLE'                  => 'Product Images: Bevel',
    'PRODUCT_IMAGE_INFO_DROP_SHADDOW_DESC'            => 'Drop Shadow<p>Throws a shadow</p>Default values: <span style="display:block">(3,333333,FFFFFF)</span><p>Usage: <span style="display:block">(shadow width, hex shadow color, hex background color)</span></p><img src="html/assets/images/legacy/config_shadow.gif">',
    'PRODUCT_IMAGE_INFO_DROP_SHADDOW_TITLE'           => 'Product Images: Drop Shadow',
    'PRODUCT_IMAGE_INFO_ELLIPSE_DESC'                 => 'Ellipse<p>Shows image in an ellipse shape</p>Default values: <span style="display:block">(FFFFFF)</span><p>Usage: <span style="display:block">(hex background color)</span></p><img src="html/assets/images/legacy/config_eclipse.gif">',
    'PRODUCT_IMAGE_INFO_ELLIPSE_TITLE'                => 'Product Images: Ellipse',
    'PRODUCT_IMAGE_INFO_FRAME_DESC'                   => 'Frame<p>Put the picture in a frame</p>Default values: <span style="display:block">(FFFFFF,000000,3,EEEEEE)</span><p>Usage: <span style="display:block">(hex light color, hex dark color, int width of mid bit, hex frame color [optional - defaults to halfway between light and dark edges])</span></p><img src="html/assets/images/legacy/config_frame.gif">',
    'PRODUCT_IMAGE_INFO_FRAME_TITLE'                  => 'Product Images: Frame',
    'PRODUCT_IMAGE_INFO_GREYSCALE_DESC'               => 'Black/White<p>Replaces the red, green and blue components with the specified gray tone (0-255 = black to white)</p>Default values: <span style="display:block">(32,22,22)</span><p>Usage: <span style="display:block">(number red, number green, number blue)</span></p><img src="html/assets/images/legacy/config_greyscale.gif">',
    'PRODUCT_IMAGE_INFO_GREYSCALE_TITLE'              => 'Product Images: Black/White',
    'PRODUCT_IMAGE_INFO_HEIGHT_DESC'                  => 'Maximum height of product info images in pixels',
    'PRODUCT_IMAGE_INFO_HEIGHT_TITLE'                 => 'Height of Product Info Images',
    'PRODUCT_IMAGE_INFO_MERGE_DESC'                   => 'Watermark<p>Sets a watermark</p>Default values: <span style="display:block">(overlay.gif,10,-50,60,FF0000)</span><p>Usage: <span style="display:block">(merge image, x start [neg = from right], y start [neg = from base], opacity, transparent color on merge image)</span></p><img src="html/assets/images/legacy/config_merge.gif">',
    'PRODUCT_IMAGE_INFO_MERGE_TITLE'                  => 'Product Images: Watermark',
    'PRODUCT_IMAGE_INFO_MOTION_BLUR_DESC'             => 'Overlapping Effect<p>Overlaps the image several times</p>Default values: <span style="display:block">(4,FFFFFF)</span><p>Usage: <span style="display:block">(int number of lines, hex background color)</span></p><img src="html/assets/images/legacy/config_motion.gif">',
    'PRODUCT_IMAGE_INFO_MOTION_BLUR_TITLE'            => 'Product Images: Overlapping Effect',
    'PRODUCT_IMAGE_INFO_ROUND_EDGES_DESC'             => 'Round Edges<p>Corner trimming</p>Default values: <span style="display:block">(5,FFFFFF,3)</span><p>Usage: <span style="display:block">(edge_radius, background color, anti-alias width)</span></p><img src="html/assets/images/legacy/config_edge.gif">',
    'PRODUCT_IMAGE_INFO_ROUND_EDGES_TITLE'            => 'Product Images: Round Edges',
    'PRODUCT_IMAGE_INFO_WIDTH_DESC'                   => 'Maximum width of product info images in pixels',
    'PRODUCT_IMAGE_INFO_WIDTH_TITLE'                  => 'Width of Product Info Images',
    'PRODUCT_IMAGE_POPUP_BEVEL_DESC'                  => 'Bevel<p>Edges look chamfered thanks to the shade</p>Default values: <span style="display:block">(8,FFCCCC,330000)</span><p>Usage: <span style="display:block">(edge width, hex light colour, hex dark colour)</span></p><img src="html/assets/images/legacy/config_bevel.gif">',
    'PRODUCT_IMAGE_POPUP_BEVEL_TITLE'                 => 'Product Pop-up Images: Bevel',
    'PRODUCT_IMAGE_POPUP_DROP_SHADDOW_DESC'           => 'Drop Shadow<p>Throws a shadow</p>Default values: <span style="display:block">(3,333333,FFFFFF)</span><p>Usage: <span style="display:block">(shadow width, hex shadow color, hex background color)</span></p><img src="html/assets/images/legacy/config_shadow.gif">',
    'PRODUCT_IMAGE_POPUP_DROP_SHADDOW_TITLE'          => 'Product Pop-up Images: Drop Shadow',
    'PRODUCT_IMAGE_POPUP_ELLIPSE_DESC'                => 'Ellipse<p>Shows image in an ellipse shape</p>Default values: <span style="display:block">(FFFFFF)</span><p>Usage: <span style="display:block">(hex background color)</span></p><img src="html/assets/images/legacy/config_eclipse.gif">',
    'PRODUCT_IMAGE_POPUP_ELLIPSE_TITLE'               => 'Product Pop-up Images: Ellipse',
    'PRODUCT_IMAGE_POPUP_FRAME_DESC'                  => 'Frame<p>Put the picture in a frame</p>Default values: <span style="display:block">(FFFFFF,000000,3,EEEEEE)</span><p>Usage: <span style="display:block">(hex light color, hex dark color, int width of mid bit, hex frame color [optional - defaults to halfway between light and dark edges])</span></p><img src="html/assets/images/legacy/config_frame.gif">',
    'PRODUCT_IMAGE_POPUP_FRAME_TITLE'                 => 'Product Pop-up Images: Frame',
    'PRODUCT_IMAGE_POPUP_GREYSCALE_DESC'              => 'Black/White<p>Replaces the red, green and blue components with the specified gray tone (0-255 = black to white)</p>Default values: <span style="display:block">(32,22,22)</span><p>Usage: <span style="display:block">(number red, number green, number blue)</span></p><img src="html/assets/images/legacy/config_greyscale.gif">',
    'PRODUCT_IMAGE_POPUP_GREYSCALE_TITLE'             => 'Product Pop-up Images: Black/White',
    'PRODUCT_IMAGE_POPUP_HEIGHT_DESC'                 => 'Maximum height of pop-up images in pixels',
    'PRODUCT_IMAGE_POPUP_HEIGHT_TITLE'                => 'Height of Pop-up Images',
    'PRODUCT_IMAGE_POPUP_MERGE_DESC'                  => 'Watermark<p>Sets a watermark</p>Default values: <span style="display:block">(overlay.gif,10,-50,60,FF0000)</span><p>Usage: <span style="display:block">(merge image, x start [neg = from right], y start [neg = from base], opacity, transparent color on merge image)</span></p><img src="html/assets/images/legacy/config_merge.gif">',
    'PRODUCT_IMAGE_POPUP_MERGE_TITLE'                 => 'Product Pop-up Images: Watermark',
    'PRODUCT_IMAGE_POPUP_MOTION_BLUR_DESC'            => 'Overlapping Effect<p>Overlaps the image several times</p>Default values: <span style="display:block">(4,FFFFFF)</span><p>Usage: <span style="display:block">(int number of lines, hex background color)</span></p><img src="html/assets/images/legacy/config_motion.gif">',
    'PRODUCT_IMAGE_POPUP_MOTION_BLUR_TITLE'           => 'Product Pop-up Images: Overlapping Effect',
    'PRODUCT_IMAGE_POPUP_ROUND_EDGES_DESC'            => 'Round Edges<p>Corner trimming</p>Default values: <span style="display:block">(5,FFFFFF,3)</span><p>Usage: <span style="display:block">(edge_radius, background color, anti-alias width)</span></p><img src="html/assets/images/legacy/config_edge.gif">',
    'PRODUCT_IMAGE_POPUP_ROUND_EDGES_TITLE'           => 'Product Pop-up Images: Round Edges',
    'PRODUCT_IMAGE_POPUP_WIDTH_DESC'                  => 'Maximum width of pop-up images in pixels',
    'PRODUCT_IMAGE_POPUP_WIDTH_TITLE'                 => 'Width of Pop-up Images',
    'PRODUCT_IMAGE_THUMBNAIL_BEVEL_DESC'              => 'Bevel<p>Edges look chamfered thanks to the shade</p>Default values: <span style="display:block">(8,FFCCCC,330000)</span><p>Usage: <span style="display:block">(edge width, hex light colour, hex dark colour)</span></p><img src="html/assets/images/legacy/config_bevel.gif">',
    'PRODUCT_IMAGE_THUMBNAIL_BEVEL_TITLE'             => 'Product Thumbnails: Bevel',
    'PRODUCT_IMAGE_THUMBNAIL_DROP_SHADDOW_DESC'       => 'Drop Shadow<p>Throws a shadow</p>Default values: <span style="display:block">(3,333333,FFFFFF)</span><p>Usage: <span style="display:block">(shadow width, hex shadow color, hex background color)</span></p><img src="html/assets/images/legacy/config_shadow.gif">',
    'PRODUCT_IMAGE_THUMBNAIL_DROP_SHADDOW_TITLE'      => 'Product Thumbnails: Drop Shadow',
    'PRODUCT_IMAGE_THUMBNAIL_ELLIPSE_DESC'            => 'Ellipse<p>Shows image in an ellipse shape</p>Default values: <span style="display:block">(FFFFFF)</span><p>Usage: <span style="display:block">(hex background color)</span></p><img src="html/assets/images/legacy/config_eclipse.gif">',
    'PRODUCT_IMAGE_THUMBNAIL_ELLIPSE_TITLE'           => 'Product Thumbnails: Ellipse',
    'PRODUCT_IMAGE_THUMBNAIL_FRAME_DESC'              => 'Frame<p>Put the picture in a frame</p>Default values: <span style="display:block">(FFFFFF,000000,3,EEEEEE)</span><p>Usage: <span style="display:block">(hex light color, hex dark color, int width of mid bit, hex frame color [optional - defaults to halfway between light and dark edges])</span></p><img src="html/assets/images/legacy/config_frame.gif">',
    'PRODUCT_IMAGE_THUMBNAIL_FRAME_TITLE'             => 'Product Thumbnails: Frame',
    'PRODUCT_IMAGE_THUMBNAIL_GREYSCALE_DESC'          => 'Black/White<p>Replaces the red, green and blue components with the specified gray tone (0-255 = black to white)</p>Default values: <span style="display:block">(32,22,22)</span><p>Usage: <span style="display:block">(number red, number green, number blue)</span></p><img src="html/assets/images/legacy/config_greyscale.gif">',
    'PRODUCT_IMAGE_THUMBNAIL_GREYSCALE_TITLE'         => 'Product Thumbnails: Black/White',
    'PRODUCT_IMAGE_THUMBNAIL_HEIGHT_DESC'             => 'Maximum height of product thumbnails in pixels',
    'PRODUCT_IMAGE_THUMBNAIL_HEIGHT_TITLE'            => 'Height of Product Thumbnails',
    'PRODUCT_IMAGE_THUMBNAIL_MERGE_DESC'              => 'Watermark<p>Sets a watermark</p>Default values: <span style="display:block">(overlay.gif,10,-50,60,FF0000)</span><p>Usage: <span style="display:block">(merge image, x start [neg = from right], y start [neg = from base], opacity, transparent color on merge image)</span></p><img src="html/assets/images/legacy/config_merge.gif">',
    'PRODUCT_IMAGE_THUMBNAIL_MERGE_TITLE'             => 'Product Thumbnails: Watermark',
    'PRODUCT_IMAGE_THUMBNAIL_MOTION_BLUR_DESC'        => 'Overlapping Effect<p>Overlaps the image several times</p>Default values: <span style="display:block">(4,FFFFFF)</span><p>Usage: <span style="display:block">(int number of lines, hex background color)</span></p><img src="html/assets/images/legacy/config_motion.gif">',
    'PRODUCT_IMAGE_THUMBNAIL_MOTION_BLUR_TITLE'       => 'Product Thumbnails: Overlapping Effect',
    'PRODUCT_IMAGE_THUMBNAIL_ROUND_EDGES_DESC'        => 'Round Edges<p>Corner trimming</p>Default values: <span style="display:block">(5,FFFFFF,3)</span><p>Usage: <span style="display:block">(edge_radius, background color, anti-alias width)</span></p><img src="html/assets/images/legacy/config_edge.gif">',
    'PRODUCT_IMAGE_THUMBNAIL_ROUND_EDGES_TITLE'       => 'Product Thumbnails: Round Edges',
    'PRODUCT_IMAGE_THUMBNAIL_WIDTH_DESC'              => 'Maximum width of product thumbnails in pixels',
    'PRODUCT_IMAGE_THUMBNAIL_WIDTH_TITLE'             => 'Width of Product Thumbnails',
    'PRODUCT_LIST_FILTER_DESC'                        => 'Do you want to display the category/manufacturer filter (0=disable; 1=enable)?',
    'PRODUCT_LIST_FILTER_TITLE'                       => 'Display Category/Manufacturer Filter',
    'PRODUCT_REVIEWS_VIEW_DESC'                       => 'Number of reviews displayed in the product details page',
    'PRODUCT_REVIEWS_VIEW_TITLE'                      => 'Reviews in Product Details',
    'QUICKLINK_ACTIVATED_DESC'                        => 'The multi-link/copy function changes the handling for the "copy product to" action, it allows you to select multiple categories to copy/link a product with one click',
    'QUICKLINK_ACTIVATED_TITLE'                       => 'Activate Multi-link/Copy Function',
    'REVIEW_TEXT_MIN_LENGTH_DESC'                     => 'Minimum length of review text',
    'REVIEW_TEXT_MIN_LENGTH_TITLE'                    => 'Reviews',
    'REVOCATION_ID_DESC'                              => 'Content ID of revocation content',
    'REVOCATION_ID_TITLE'                             => 'Revocation ID',
    'SEARCH_ENGINE_FRIENDLY_URLS_DESC'                => 'Use search engine safe urls for all site links. Make sure mod_rewrite is installed on your web space.',
    'SEARCH_ENGINE_FRIENDLY_URLS_TITLE'               => 'Use Search Engine Safe URLs?',
    'SEARCH_IN_ATTR_DESC'                             => 'Activate to enable search in product attributes and product properties',
    'SEARCH_IN_ATTR_TITLE'                            => 'Search in product attributes/properties',
    'SEARCH_IN_DESC_DESC'                             => 'Activate to enable search in product descriptions',
    'SEARCH_IN_DESC_TITLE'                            => 'Search in Product Descriptions',
    'SECURITY_CODE_LENGTH_DESC'                       => 'Security code length (gift voucher)',
    'SECURITY_CODE_LENGTH_TITLE'                      => 'Security Code Length',
    'SEND_EMAIL_BY_BILLING_ADRESS_DESC'               => 'If you do not receive order confirmation emails, set this switch to <b>Owner E-Mail</b>.</span><span class="tooltip-icon" data-gx-widget="tooltip_icon" data-tooltip_icon-type="warning">Before changing the settings, please try with a test order if confirmation emails will be sent!',
    'SEND_EMAIL_BY_BILLING_ADRESS_TITLE'              => 'Sender of the order confirmation e-mails',
    'SEND_EMAILS_DESC'                                => 'Send emails',
    'SEND_EMAILS_TITLE'                               => 'Send Emails',
    'SEND_EXTRA_ORDER_E-MailS_TO_DESC'                => 'Send extra order emails to the following email addresses in this format: Name1 <email@address1>, Name2 <email@address2>',
    'SEND_EXTRA_ORDER_E-MailS_TO_TITLE'               => 'Send extra order emails to:',
    'SEND_EXTRA_ORDER_EMAILS_TO_DESC'                 => 'Send extra order emails to the following email addresses in this format: Name1 <email@address1>, Name2 <email@address2>',
    'SEND_EXTRA_ORDER_EMAILS_TO_TITLE'                => 'Send extra order emails to:',
    'SENDMAIL_PATH_DESC'                              => 'If you use sendmail, you should provide us with the correct path (default: /usr/sbin/sendmail):',
    'SENDMAIL_PATH_TITLE'                             => 'Sendmail Path',
    'SESSION_CHECK_IP_ADDRESS_DESC'                   => 'Validate the client\'s IP address at every page request.',
    'SESSION_CHECK_IP_ADDRESS_TITLE'                  => 'Check IP Address',
    'SESSION_CHECK_USER_AGENT_DESC'                   => 'Validate the client\'s browser user agent at every page request.',
    'SESSION_CHECK_USER_AGENT_TITLE'                  => 'Check User Agent',
    'SESSION_FORCE_COOKIE_USE_DESC'                   => 'Start sessions if cookies are enabled.',
    'SESSION_FORCE_COOKIE_USE_TITLE'                  => 'Favor Cookie Use',
    'SESSION_RECREATE_DESC'                           => 'Recreate the session to generate a new session ID when the customer logs on or creates an account (PHP >=4.1 required).',
    'SESSION_RECREATE_TITLE'                          => 'Recreate Session',
    'SESSION_TIMEOUT_DESC'                            => 'Determines (in minutes) how long a session remains valid. When the determined time expires the session is removed and a renewed login is necessary!',
    'SESSION_TIMEOUT_TITLE'                           => 'Session Timeout',
    'SHIPPING_BOX_PADDING_DESC'                       => 'For 10% enter 10',
    'SHIPPING_BOX_PADDING_TITLE'                      => 'Larger Packages - Percentage Increase',
    'SHIPPING_BOX_WEIGHT_DESC'                        => 'What is the weight of typical packaging of small to medium packages?',
    'SHIPPING_BOX_WEIGHT_TITLE'                       => 'Package Tare Weight',
    'SHIPPING_INFOS_DESC'                             => 'Group ID of shipping costs content.',
    'SHIPPING_INFOS_TITLE'                            => 'Group ID',
    'SHIPPING_MAX_WEIGHT_DESC'                        => 'Carriers have a max weight limit for a single package. This is common to all.',
    'SHIPPING_MAX_WEIGHT_TITLE'                       => 'Enter the Maximum Package Weight You Will Ship',
    'SHIPPING_ORIGIN_COUNTRY_DESC'                    => 'Select the country of origin to be used in shipping quotes.',
    'SHIPPING_ORIGIN_COUNTRY_TITLE'                   => 'Country of Origin',
    'SHIPPING_ORIGIN_ZIP_DESC'                        => 'Enter the postcode (ZIP code) of the store to be used in shipping quotes.',
    'SHIPPING_ORIGIN_ZIP_TITLE'                       => 'Postcode (ZIP code)',
    'SHOW_CART_SHIPPING_COSTS_DESC'                   => 'Displays an icon behind the shipping costs in the shopping cart which is linked to a shipping costs calculator.',
    'SHOW_CART_SHIPPING_COSTS_TITLE'                  => 'Shipping costs calculator in shopping cart',
    'SHOW_CART_SHIPPING_WEIGHT_DESC'                  => 'Show shipping weight in shopping cart.',
    'SHOW_CART_SHIPPING_WEIGHT_TITLE'                 => 'Shipping weight in shopping cart',
    'SHOW_COUNTS_DESC'                                => 'Count recursively how many products are in each category</span><span class="tooltip-icon" data-gx-widget="tooltip_icon" data-tooltip_icon-type="warning">Activating this option may cause negative impacts on performance and loading time',
    'SHOW_COUNTS_TITLE'                               => 'Show Category Counts',
    'SHOW_IP_LOG_DESC'                                => 'Show Text "Your IP will be saved", at checkout?',
    'SHOW_IP_LOG_TITLE'                               => 'IP Log in Checkout?',
    'SHOW_SHIPPING_DESC'                              => 'Show shipping costs link in product info',
    'SHOW_SHIPPING_TITLE'                             => 'Shipping Costs in Product Info',
    'SHOW_UNTRANSLATED_MENUITEMS_DESC'                => 'Show untranslated menuitems in administration (please delete the modules cache afterwards).',
    'SHOW_UNTRANSLATED_MENUITEMS_TITLE'               => 'Untranslated menuitems',
    'SMALL_IMAGE_HEIGHT_DESC'                         => 'The pixel height of small images',
    'SMALL_IMAGE_HEIGHT_TITLE'                        => 'Small Image Height',
    'SMALL_IMAGE_WIDTH_DESC'                          => 'The pixel width of small images',
    'SMALL_IMAGE_WIDTH_TITLE'                         => 'Small Image Width',
    'SMTP_AUTH_DESC'                                  => 'Does your SMTP server need secure authentication?',
    'SMTP_AUTH_TITLE'                                 => 'SMTP AUTH',
    'SMTP_BACKUP_SERVER_DESC'                         => 'Please enter the address of your backup SMTP server.',
    'SMTP_BACKUP_SERVER_TITLE'                        => 'SMTP Backup Server Address',
    'SMTP_ENCRYPTION_DESC'                            => 'Please select here the type of SMTP encryption.',
    'SMTP_ENCRYPTION_TITLE'                           => 'SMTP Encryption',
    'SMTP_MAIN_SERVER_DESC'                           => 'Please enter the address of your main SMTP server.',
    'SMTP_MAIN_SERVER_TITLE'                          => 'SMTP Server Address',
    'SMTP_PASSWORD_DESC'                              => 'Please enter the password for your SMTP account.',
    'SMTP_PASSWORD_TITLE'                             => 'SMTP Password',
    'SMTP_PORT_DESC'                                  => 'Please enter the SMTP port for your SMTP server (default: 25)?',
    'SMTP_PORT_TITLE'                                 => 'SMTP Port',
    'SMTP_USERNAME_DESC'                              => 'Please enter the username for your SMTP account.',
    'SMTP_USERNAME_TITLE'                             => 'SMTP Username',
    'SQL_LOG_MAX_FILESIZE_DESC'                       => 'Maximum filesize of the SQL-Logging file in MB.',
    'SQL_LOG_MAX_FILESIZE_TITLE'                      => 'Maximum Filesize',
    'STOCK_ALLOW_CHECKOUT_DESC'                       => 'Allow customer to checkout even if there is insufficient stock',
    'STOCK_ALLOW_CHECKOUT_TITLE'                      => 'Allow Checkout',
    'STOCK_CHECK_DESC'                                => 'Check to see if there is sufficent stock available',
    'STOCK_CHECK_TITLE'                               => 'Check stock level',
    'STOCK_LIMITED_DESC'                              => 'Subtract product in stock by product orders',
    'STOCK_LIMITED_TITLE'                             => 'Subtract stock',
    'STOCK_MARK_PRODUCT_OUT_OF_STOCK_DESC'            => 'Provide an on-screen indication for the customer to indicate which product has insufficient stock',
    'STOCK_MARK_PRODUCT_OUT_OF_STOCK_TITLE'           => 'Mark product out of stock',
    'STOCK_REORDER_LEVEL_DESC'                        => 'Define when stock needs to be re-ordered',
    'STOCK_REORDER_LEVEL_TITLE'                       => 'Stock Re-order Level',
    'STORE_COUNTRY_DESC'                              => 'The country in which my store is located <br /><br /><b>Note: Please remember to update the store zone.</b>',
    'STORE_COUNTRY_TITLE'                             => 'Country',
    'STORE_DB_TRANSACTIONS_DESC'                      => 'Store the database queries in the page parse time log',
    'STORE_DB_TRANSACTIONS_TITLE'                     => 'Store Database Queries',
    'STORE_NAME_ADDRESS_DESC'                         => 'This is the store name, address and phone number used on printable documents and displayed online.',
    'STORE_NAME_ADDRESS_TITLE'                        => 'Store address and phone number',
    'STORE_NAME_DESC'                                 => 'My store name',
    'STORE_NAME_TITLE'                                => 'Store Name',
    'STORE_OWNER_DESC'                                => 'The name of my store owner',
    'STORE_OWNER_EMAIL_ADDRESS_DESC'                  => 'The email address of my store owner',
    'STORE_OWNER_EMAIL_ADDRESS_TITLE'                 => 'Email Address',
    'STORE_OWNER_TITLE'                               => 'Store Owner',
    'STORE_OWNER_VAT_ID_DESC'                         => 'Store Owner VAT No.',
    'STORE_OWNER_VAT_ID_TITLE'                        => 'The store owner VAT no.',
    'STORE_PAGE_PARSE_TIME_DESC'                      => 'Store the time it takes to parse a page',
    'STORE_PAGE_PARSE_TIME_LOG_DESC'                  => 'Directory and filename of the page parse time log',
    'STORE_PAGE_PARSE_TIME_LOG_TITLE'                 => 'Log Destination',
    'STORE_PAGE_PARSE_TIME_TITLE'                     => 'Store Page Parse Time',
    'STORE_ZONE_DESC'                                 => 'The zone in which my store is located.',
    'STORE_ZONE_TITLE'                                => 'Zone',
    'SUBCATEGORY_IMAGE_HEIGHT_DESC'                   => 'The pixel height of sub-category images',
    'SUBCATEGORY_IMAGE_HEIGHT_TITLE'                  => 'Sub-category Image Height',
    'SUBCATEGORY_IMAGE_WIDTH_DESC'                    => 'The pixel width of sub-category images',
    'SUBCATEGORY_IMAGE_WIDTH_TITLE'                   => 'Sub-category Image Width',
    'TABLE_HEADING_ACTION'                            => 'Action',
    'TABLE_HEADING_CONFIGURATION_TITLE'               => 'Title',
    'TABLE_HEADING_CONFIGURATION_VALUE'               => 'Value',
    'TEXT_INFO_DATE_ADDED'                            => 'Date Added:',
    'TEXT_INFO_EDIT_INTRO'                            => 'Please make any necessary changes',
    'TEXT_INFO_LAST_MODIFIED'                         => 'Last Modified:',
    'TRADER_FAX_DESC'                                 => 'Fax number of the store owner',
    'TRADER_FAX_TITLE'                                => 'Fax',
    'TRADER_FIRSTNAME_DESC'                           => 'First name of the store owner',
    'TRADER_FIRSTNAME_TITLE'                          => 'Firstname',
    'TRADER_LOCATION_DESC'                            => 'Location of the principal office',
    'TRADER_LOCATION_TITLE'                           => 'Location',
    'TRADER_NAME_DESC'                                => 'Last name of the store owner',
    'TRADER_NAME_TITLE'                               => 'Name',
    'TRADER_STREET_DESC'                              => 'Street of the principal office',
    'TRADER_STREET_NUMBER_DESC'                       => 'Street number of the principal office',
    'TRADER_STREET_NUMBER_TITLE'                      => 'Street number',
    'TRADER_STREET_TITLE'                             => 'Street',
    'TRADER_TEL_DESC'                                 => 'Phone number of the store owner',
    'TRADER_TEL_TITLE'                                => 'Phone',
    'TRADER_ZIPCODE_DESC'                             => 'Zipcode of the principal office',
    'TRADER_ZIPCODE_TITLE'                            => 'Zipcode',
    'UNFOLD_FAVS_BOX_DESC'                            => '',
    'UNFOLD_FAVS_BOX_TITLE'                           => 'Favourites box always unfolded',
    'UPDATE_ORDER_EMAIL_SUBJECT_TEXT'                 => 'Your order',
    'USE_BUSTFILES_TITLE'                             => 'Cache-friendly file names',
    'USE_BUSTFILES_DESC'                              => 'Inject cache-busting parameter in file names instead of query strings',
    'USE_CACHE_DESC'                                  => 'Use caching features',
    'USE_CACHE_TITLE'                                 => 'Use Cache',
    'USE_DEFAULT_LANGUAGE_CURRENCY_DESC'              => 'Automatically switch to the currency of the language when it is changed.',
    'USE_DEFAULT_LANGUAGE_CURRENCY_TITLE'             => 'Automatically switch to language currency',
    'USE_WYSIWYG_DESC'                                => 'Activate WYSIWYG editor for CMS and products',
    'USE_WYSIWYG_TITLE'                               => 'Activate WYSIWYG Editor',
];
